(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15442,        513]*)
(*NotebookOutlinePosition[     16550,        550]*)
(*  CellTagsIndexPosition[     16506,        546]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[CellGroupData[{Cell[TextData[{
  "What 'Solution' Means\n",
  StyleBox["Some Examples",
    FontSize->14]
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Once one is familiar with the idea of an ordinary differential equation as \
an equation involving an unknown function of one (real) variable and one or \
more of the derivatives of that function, the next natural question is: do \
differential equations have solutions? Well, some do and some don't. For some \
classes of differential equations, it is easy to find solutions; for others, \
it is extremely difficult. But exactly what is meant by the statement that \
y[x] is a solution of some differential equation'?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[TextData["Theory (Simplified)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given a differential equation of the form ",
  StyleBox["F[x,y[x],y'[x],y''[x],...]==0",
    FontWeight->"Bold"],
  ", a function ",
  StyleBox["y=g[x]",
    FontWeight->"Bold"],
  " is a solution of the differential equation on some interval [a, b] \
provided that ",
  StyleBox["g[x]",
    FontWeight->"Bold"],
  " makes the equation ",
  StyleBox["F[x,g[x],g'[x],g''[x],...]==0",
    FontWeight->"Bold"],
  " an identity in x, that is, for each number x in the interval [a, b] the \
equation ",
  StyleBox["F[x,g[x],g'[x],g''[x],...]==0",
    FontWeight->"Bold"],
  " is true. \n(",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  uses the symbol ",
  StyleBox["True",
    FontWeight->"Bold"],
  " for true.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[TextData["A Reminder: Notations for the derivative"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "You can use ",
  StyleBox["D[expr,x]",
    FontWeight->"Bold"],
  " to calculate the first derivative of any expression which is a function \
which is a function of x. ",
  StyleBox["D[expr,x,x]",
    FontWeight->"Bold"],
  " or ",
  StyleBox["D[expr,{x,2}]",
    FontWeight->"Bold"],
  " calculates a second derivative of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ". Higher order derivatives can be denoted similarly. If you have a named \
function, such as you might define by",
  StyleBox[" f[x_]=expr",
    FontWeight->"Bold"],
  ", then you can denote derivatives simply as f'[x], f''[x], and so on. This \
latter notation does ",
  StyleBox["require",
    FontVariations->{"Underline"->True}],
  " that the function be named."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Show that y=Exp[x^2] is a solution of y'-2*x*y==0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(y[x_] = c\ Exp[x\^2]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c\ E\^\(x\^2\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "-", 
          \(2\ x\ y[x]\)}], "==", "0"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "It's that easy! Note that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  has hidden all of its work from you. You may calculate the derivative \
separately, if you wish to check your work as you do the steps manually. For \
instance, here is the first derivative: "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{
      SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ E\^\(x\^2\)\ x\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that y=c1 Sin[a t] + c2 Cos[a t]  is a solution of  y''+a^2 y==0. We \
first need to clear out the previous definition of y[x_]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[y]\), 
    \(y[t_] = c1\ Sin[a\ t] + c2\ Cos[a\ t]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c2\ Cos[a\ t] + c1\ Sin[a\ t]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}], "+", 
          \(a\^2\ y[t]\)}], "==", "0"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 3"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that y=a1 Exp[2x]+ a2 x Exp[2x]   is a solution of  y''-4y'+4 y==0. We \
first need to clear out the previous definition of y[x_]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[x, y, a1, a2]\), 
    \(y[x_] = a1\ Exp[2\ x] + a2\ x\ Exp[2\ x]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(a1\ E\^\(2\ x\) + a2\ E\^\(2\ x\)\ x\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "-", 
          RowBox[{"4", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          \(4\ y[x]\)}], "==", "0"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 4"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Show that y=6 Tan[6x] is a solution of y'==36+y^2."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[y]\), 
    \(y[x_] = 6\ Tan[6\ x]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(6\ Tan[6\ x]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData["Here is a first attempt:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "==", 
      \(36 + y[x]\^2\)}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(36\ Sec[6\ x]\^2 == 36 + 36\ Tan[6\ x]\^2\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Do you remember an identity which reduces the right hand side to the left \
hand side? Look it up. The two sides agree, as we see if we let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  ",
  StyleBox["Simplify",
    FontWeight->"Bold"],
  " the expression. (We do have to be careful not to let  x be certain \
multiples of Pi/12.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "==", 
        \(36 + y[x]\^2\)}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 5"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that P=a*c1*Exp[a*t]/(1+b*c1*Exp[a*t]) is a solution of the \
differential equation dP/dt = P(a - b*P)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(P[t_] = \(a\ c1\ Exp[a\ t]\)\/\(1 + b\ c1\ Exp[a\ t]\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(a\ c1\ E\^\(a\ t\)\)\/\(1 + b\ c1\ E\^\(a\ t\)\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["P", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "==", 
        \(P[t]\ \((a - b\ P[t])\)\)}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "No intermediate results are shown, but you can obtain them yourself by \
telling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to make the calcultions you want, such as:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{
      SuperscriptBox["P", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\(\(E\^\(2\ a\ t\)\ a\^2\ b\ c1\^2\)\/\((1 + E\^\(a\ t\)\ b\ c1)\)\^2
              \)\) + \(E\^\(a\ t\)\ a\^2\ c1\)\/\(1 + E\^\(a\ t\)\ b\ c1\)\)],
   "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 6"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Show that y=x*Cos[Log[x]] is a solution of x^2*y''-x*y'+2y==0. \n",
  StyleBox["(Log[x] is ",
    FontSize->10],
  StyleBox["Mathematica",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox[
  "'s notation for the natural logarithm of x, more commonly written ln x.)",
    FontSize->10]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[y]\), 
    \(y[x_] = x\ Cos[Log[x]]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\ Cos[Log[x]]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{\(x\^2\), " ", 
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"x", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          \(2\ y[x]\)}], "==", "0"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[
"Again, you may make any intermediate calculation which you would like to \
see. Sometimes it is instructive to see a result before simplifying it:"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", \(2\ y[x]\)}],
       "==", "0"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\ Cos[Log[x]] - x\ \((Cos[Log[x]] - Sin[Log[x]])\) + 
        x\^2\ \((\(-\(Cos[Log[x]]\/x\)\) - Sin[Log[x]]\/x)\) == 0\)], "Output",\

  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 7"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that y=c1*Sin[3x]+c2*Cos[3x]+c3*Exp[x] is a solution of the \
differential equation y'''-y''+9y'-9y==0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[y]\), 
    \(y[x_] = c1\ Sin[3\ x] + c2\ Cos[3\ x] + c3\ Exp[x]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(E\^x\ c3 + c2\ Cos[3\ x] + c1\ Sin[3\ x]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "-", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "+", 
          RowBox[{"9", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          \(9\ y[x]\)}], "==", "0"}], "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]]}, Open]]}, Open]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{36, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 155, 6, 70, "Subtitle"],
Cell[1889, 59, 594, 9, 70, "Text"],

Cell[CellGroupData[{
Cell[2506, 70, 97, 2, 70, "Section"],
Cell[2606, 74, 801, 27, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[3439, 103, 86, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[3548, 107, 121, 2, 70, "Subsection"],
Cell[3672, 111, 820, 25, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[4524, 138, 90, 2, 70, "Subsection"],
Cell[4617, 142, 125, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[4765, 146, 80, 2, 70, "Input"],
Cell[4848, 150, 97, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4977, 155, 286, 8, 70, "Input"],
Cell[5266, 165, 87, 3, 70, "Output"]
}, Closed]],
Cell[5365, 170, 358, 9, 70, "Text"],

Cell[CellGroupData[{
Cell[5746, 181, 152, 4, 70, "Input"],
Cell[5901, 187, 100, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6042, 192, 90, 2, 70, "Subsection"],
Cell[6135, 196, 209, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[6367, 202, 118, 3, 70, "Input"],
Cell[6488, 207, 112, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6632, 212, 292, 8, 70, "Input"],
Cell[6927, 222, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7055, 227, 90, 2, 70, "Subsection"],
Cell[7148, 231, 211, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[7382, 237, 131, 3, 70, "Input"],
Cell[7516, 242, 118, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7666, 247, 452, 12, 70, "Input"],
Cell[8121, 261, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8249, 266, 90, 2, 70, "Subsection"],
Cell[8342, 270, 125, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[8490, 274, 101, 3, 70, "Input"],
Cell[8594, 279, 95, 3, 70, "Output"]
}, Closed]],
Cell[8701, 284, 99, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[8823, 288, 204, 6, 70, "Input"],
Cell[9030, 296, 124, 3, 70, "Output"]
}, Closed]],
Cell[9166, 301, 425, 12, 70, "Text"],

Cell[CellGroupData[{
Cell[9614, 315, 250, 7, 70, "Input"],
Cell[9867, 324, 86, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9994, 329, 90, 2, 70, "Subsection"],
Cell[10087, 333, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[10294, 339, 114, 2, 70, "Input"],
Cell[10411, 343, 133, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10576, 348, 262, 7, 70, "Input"],
Cell[10841, 357, 87, 3, 70, "Output"]
}, Closed]],
Cell[10940, 362, 263, 8, 70, "Text"],

Cell[CellGroupData[{
Cell[11226, 372, 152, 4, 70, "Input"],
Cell[11381, 378, 233, 5, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11655, 385, 90, 2, 70, "Subsection"],
Cell[11748, 389, 370, 12, 70, "Text"],

Cell[CellGroupData[{
Cell[12141, 403, 103, 3, 70, "Input"],
Cell[12247, 408, 97, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12376, 413, 494, 13, 70, "Input"],
Cell[12873, 428, 87, 3, 70, "Output"]
}, Closed]],
Cell[12972, 433, 225, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[13220, 440, 433, 12, 70, "Input"],
Cell[13656, 454, 208, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[13896, 461, 71, 2, 70, "Input"],
Cell[13970, 465, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14098, 470, 90, 2, 70, "Subsection"],
Cell[14191, 474, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[14398, 480, 131, 3, 70, "Input"],
Cell[14532, 485, 123, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14687, 490, 626, 17, 70, "Input"],
Cell[15316, 509, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
